program p_7_3;

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////}
uses crt, graf_fx;

{// M O J E  T Y P Y  D A N Y C H
{///////////////////////////////////////}

type kula = record
              poz_x : integer;
              poz_y : integer;
              delta_x : integer;
              delta_y : integer;
              czy_dziala : boolean;
              energia : integer;
              czy_umiera : boolean;
              licznik_klatek_smierci : byte;
            end;

{// Z M I E N N E   G L O B A L N E
{///////////////////////////////////////}
var
docelowy, zrodlowy : prostokat;
klatki_kulek : obraz;
tab_obiektow : array[0..19] of kula;
adres_2_bufora : pointer;

{// P R O C E D U R Y
{///////////////////////////////////////}

procedure inicjuj_obiekty;
var
licznik : byte;
begin
randomize;

for licznik := 0 to 19 do
begin

{losowe ustalenie poczatkowej pozycji kuli}
tab_obiektow[licznik].poz_x := 10 + random(280);
tab_obiektow[licznik].poz_y := 10 + random(170);

{losowe ustalenie poziomego przesuniecia}
if (random(2) = 0) then
tab_obiektow[licznik].delta_x := random(3) + 1 else
tab_obiektow[licznik].delta_x := -(random(3) + 1);

{losowe ustalenie pionowego przesuniecia}
if(random(2) = 0) then
tab_obiektow[licznik].delta_y := random(3) + 1 else
tab_obiektow[licznik].delta_y := -(random(3) + 1);

{ustalenie wartosci pozostalych pol}
tab_obiektow[licznik].czy_dziala := TRUE;
tab_obiektow[licznik].energia := 100;
tab_obiektow[licznik].czy_umiera := FALSE;
tab_obiektow[licznik].licznik_klatek_smierci := 0;
end; {koniec petli for}

end; {koniec procedury inicjuj_obiekty}

{---------------}

procedure wyswietl_obiekty;
var
licznik : byte;
begin

for licznik := 0 to 19 do
begin

{jeali kula nie dziala to sie nia nie zajmujemy}
if(tab_obiektow[licznik].czy_dziala = FALSE) then continue;

{jezeli kula dziala i nie obumiera}
if(tab_obiektow[licznik].czy_umiera = FALSE) then
begin

{ustlanie kopiowanego fragmentu obrazu}
g_wypelnij_p(zrodlowy, 0, 0, 20, 20);

{ustlenie miejsca kopiowania obrazu}
g_wypelnij_p(docelowy, tab_obiektow[licznik].poz_x,
                       tab_obiektow[licznik].poz_y, 20, 20);

{narysowanie kuli}
g_wyswietl_obraz_13h_k(adres_2_bufora, zrodlowy, docelowy,
                       klatki_kulek, TRUE, klatki_kulek.wsk_obrazu^[0]);

{sprawdzenie czy kula udezyla w lewa lub prawa krawedz ekranu}
if((tab_obiektow[licznik].poz_x + tab_obiektow[licznik].delta_x > 299) or
   (tab_obiektow[licznik].poz_x + tab_obiektow[licznik].delta_x < 0)) then
    begin
    tab_obiektow[licznik].delta_x := -tab_obiektow[licznik].delta_x;
    dec(tab_obiektow[licznik].energia, 6)
    end;
{sprawdzenie czy kula udezyla w dolna lub gorna krawedz ekranu}
if((tab_obiektow[licznik].poz_y + tab_obiektow[licznik].delta_y > 179) or
   (tab_obiektow[licznik].poz_y + tab_obiektow[licznik].delta_y < 0)) then
   begin
    tab_obiektow[licznik].delta_y := -tab_obiektow[licznik].delta_y;
    dec(tab_obiektow[licznik].energia, 6);
   end;

{przesuniecie obiektu}
   inc(tab_obiektow[licznik].poz_x, tab_obiektow[licznik].delta_x);
   inc(tab_obiektow[licznik].poz_y, tab_obiektow[licznik].delta_y);

{jezeli kula stracila cala energie uruchamiamy jej obumieranie}
if(tab_obiektow[licznik].energia < 0) then
   tab_obiektow[licznik].czy_umiera := TRUE;

end else {blok wykonywany jezeli czy_umiera = TRUE}
begin

{ustalenie kopiowanego fragmentu obrazu}
g_wypelnij_p(zrodlowy,
             (tab_obiektow[licznik].licznik_klatek_smierci mod 5)*20,
             (tab_obiektow[licznik].licznik_klatek_smierci div 5)*20,
              20, 20);

{ustalenie miejsca kopiowania obrazu}
g_wypelnij_p(docelowy, tab_obiektow[licznik].poz_x,
                       tab_obiektow[licznik].poz_y, 20, 20);

{wyswietlenie obrazu kuli}
g_wyswietl_obraz_13h_k(adres_2_bufora, zrodlowy, docelowy,
                       klatki_kulek, TRUE, klatki_kulek.wsk_obrazu^[0]);

{zwiekszamy wartosc licznika klatek smierci, jezeli przekroczy wartosc 19
 uznajemy obiekt za martwy (niedzilajacy)}
inc(tab_obiektow[licznik].licznik_klatek_smierci);
if(tab_obiektow[licznik].licznik_klatek_smierci > 19) then
   tab_obiektow[licznik].czy_dziala := FALSE;

end; {koniec bloku else}

end; {koniec petli for}

end; {koniec procedury wyswietl_obiekty}

{// G L O W N Y   P R O G R A M
{///////////////////////////////////////}

begin
{inicjalizacja zmiennych}
inicjuj_obiekty;

{wlanczamy tryb graficzny 320x200x256}
g_ustaw_tryb_vga($13);

{zaladowanie klatek animacji kulki}
g_laduj_BMP_13h(klatki_kulek, 'kulki.bmp');

{zaladowanie palety kolorow}
g_laduj_palete_BMP('kulki.bmp');

{pobranie pamieci dla drugiego buforaw wideo i jego adresu}
g_pobierz_pam_dla_drugiego_bufora(adres_2_bufora);

{petla wykonuje sie do momentu nacisniecia dowolnego klawisza}
while not(keypressed) do
begin

{zamlowanie bufora na jeden kolor}
g_wypelnij_bufor(adres_2_bufora, 40);

{wyswietl i przesun obiekty}
wyswietl_obiekty;

{czkamy na powrot pionowy poczym kopiujemy zawartosc drugiego
 bufora wideo do pierwszego bufora}
g_czekaj_na_powrot_pionowy;
g_kopiuj_bufor(ptr($A000,0000), adres_2_bufora);

end; {koniec petli while do}

{zwolnienie pamieci przydzielonej pod klatki animacji i drugi bufor wideo}
g_zwolnij_pam(klatki_kulek);
g_zwolnij_pam_bufora(adres_2_bufora);

end. {koniec programu}